/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASIHandler;
import com.ibm.ras.RASITraceLogger;
import com.ibm.ras.RASLogger;
import com.ibm.ras.RASTraceEvent;
import java.util.Enumeration;
import java.util.Hashtable;

public class RASTraceLogger
extends RASLogger
implements RASITraceLogger {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final String ENTRY = "Entry";
    private static final String EXIT = "Exit";
    private long traceMask = 2047L;

    public RASTraceLogger() {
        this("", "");
    }

    public RASTraceLogger(String string) {
        this(string, "");
    }

    public RASTraceLogger(String string, String string2) {
        super(string, string2);
    }

    public RASTraceLogger(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
    }

    public Hashtable getConfig() {
        Hashtable hashtable = super.getConfig();
        hashtable.put("traceMask", RASTraceEvent.maskToString(this.getTraceMask()));
        return hashtable;
    }

    public void setConfig(Hashtable hashtable) {
        super.setConfig(hashtable);
        if (hashtable.containsKey("traceMask")) {
            this.setTraceMask(RASTraceEvent.maskLongValue((String)hashtable.get("traceMask")));
        }
    }

    public long getTraceMask() {
        return this.traceMask;
    }

    public void setTraceMask(long l) {
        this.traceMask = l;
        this.maskValueChanged();
    }

    public void entry(long l, Object object, String string) {
        String string2 = object.getClass().getName();
        this.trace(l |= 4L, string2, string, ENTRY, (Object[])null);
    }

    public void entry(long l, Object object, String string, Object object2) {
        String string2 = object.getClass().getName();
        Object[] objectArray = new Object[]{object2};
        this.trace(l |= 4L, string2, string, ENTRY, objectArray);
    }

    public void entry(long l, Object object, String string, Object object2, Object object3) {
        String string2 = object.getClass().getName();
        Object[] objectArray = new Object[]{object2, object3};
        this.trace(l |= 4L, string2, string, ENTRY, objectArray);
    }

    public void entry(long l, Object object, String string, Object[] objectArray) {
        String string2 = object.getClass().getName();
        this.trace(l |= 4L, string2, string, ENTRY, objectArray);
    }

    public void entry(long l, String string, String string2) {
        this.trace(l |= 4L, string, string2, ENTRY, (Object[])null);
    }

    public void entry(long l, String string, String string2, Object object) {
        Object[] objectArray = new Object[]{object};
        this.trace(l |= 4L, string, string2, ENTRY, objectArray);
    }

    public void entry(long l, String string, String string2, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        this.trace(l |= 4L, string, string2, ENTRY, objectArray);
    }

    public void entry(long l, String string, String string2, Object[] objectArray) {
        this.trace(l |= 4L, string, string2, ENTRY, objectArray);
    }

    public void exit(long l, Object object, String string) {
        String string2 = object.getClass().getName();
        this.trace(l |= 4L, string2, string, EXIT, (Object[])null);
    }

    public void exit(long l, Object object, String string, Object object2) {
        String string2 = object.getClass().getName();
        Object[] objectArray = new Object[]{object2};
        this.trace(l |= 4L, string2, string, EXIT, objectArray);
    }

    public void exit(long l, String string, String string2) {
        this.trace(l |= 4L, string, string2, EXIT, (Object[])null);
    }

    public void exit(long l, String string, String string2, Object object) {
        Object[] objectArray = new Object[]{object};
        this.trace(l |= 4L, string, string2, EXIT, objectArray);
    }

    public void trace(long l, Object object, String string, String string2) {
        String string3 = object.getClass().getName();
        this.trace(l, string3, string, string2, (Object[])null);
    }

    public void trace(long l, Object object, String string, String string2, Object object2) {
        String string3 = object.getClass().getName();
        Object[] objectArray = new Object[]{object2};
        this.trace(l, string3, string, string2, objectArray);
    }

    public void trace(long l, Object object, String string, String string2, Object object2, Object object3) {
        String string3 = object.getClass().getName();
        Object[] objectArray = new Object[]{object2, object3};
        this.trace(l, string3, string, string2, objectArray);
    }

    public void trace(long l, Object object, String string, String string2, Object[] objectArray) {
        String string3 = object.getClass().getName();
        this.trace(l, string3, string, string2, objectArray);
    }

    public void trace(long l, String string, String string2, String string3) {
        this.trace(l, string, string2, string3, (Object[])null);
    }

    public void trace(long l, String string, String string2, String string3, Object object) {
        Object[] objectArray = new Object[]{object};
        this.trace(l, string, string2, string3, objectArray);
    }

    public void trace(long l, String string, String string2, String string3, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        this.trace(l, string, string2, string3, objectArray);
    }

    public void trace(long l, String string, String string2, String string3, Object[] objectArray) {
        String[] stringArray = null;
        if (this.isLoggable(l)) {
            if (objectArray != null) {
                stringArray = new String[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    stringArray[n] = objectArray[n].toString();
                    ++n;
                }
            }
            RASTraceEvent rASTraceEvent = new RASTraceEvent(l, string3, stringArray, string, string2, this, this.getServer(), this.getClient(), null);
            this.fireRASEvent(rASTraceEvent);
        }
    }

    public void exception(long l, Object object, String string, Exception exception) {
        String string2 = object.getClass().getName();
        this.exception(l, string2, string, exception);
    }

    public void exception(long l, String string, String string2, Exception exception) {
        if (this.isLoggable(l)) {
            RASTraceEvent rASTraceEvent = new RASTraceEvent(l, null, null, string, string2, this, this.getServer(), this.getClient(), exception);
            this.fireRASEvent(rASTraceEvent);
        }
    }

    public synchronized void maskValueChanged() {
        this.isLoggableMask = 0L;
        Enumeration enumeration = this.getHandlers();
        while (enumeration.hasMoreElements()) {
            RASIHandler rASIHandler = (RASIHandler)enumeration.nextElement();
            this.isLoggableMask |= rASIHandler.getTraceMask();
        }
        this.isLoggableMask &= this.getTraceMask();
    }
}

